/*
 * Resource.h
 *
 *  Created on: 14.07.2011
 *      Author: stefan.detter
 */

#ifndef RESOURCE_H_
#define RESOURCE_H_

#include <QObject>
#include <QStringList>
#include <QUrl>
#include <QFileInfo>

#include <QrfeTraceModule>


class Resource : public QObject, QrfeTraceModule
{
	Q_OBJECT

public:
	typedef enum {
		SoundResource,
		FimrwareResource,
		TestFimrwareResource,
		BootloaderResource,
	} ResourceType;

	Resource(QObject* parent = 0);
	virtual ~Resource();

	void init();

	void startImport();

public:
	QFileInfoList 	soundFiles();
	QFileInfoList 	firmwareFiles();
	QFileInfoList 	testFirmwareFiles();
	QFileInfoList 	bootloaderFiles();

	void tryAddUrlToResource ( const QUrl& url, QString &result, uint &count, uint &successfull);
	bool copyFileToResource ( const QFileInfo& file , const ResourceType& type, const QString& subDir, QFileInfo& newFile );

signals:
	void addFileRequest ( const QFileInfo& file, bool& yesToAll , bool& result, QString& errMsg );

public:
	static Resource* 	d;
	static void initInstance(QObject* parent = 0);

private:
	void searchFolderForFilesToAdd(QString dirPath, uint level, QString& report, uint &count, uint &successfull);
	bool tryAddFileToResource ( const QFileInfo& fileInfo, QString& errMsg );

	QFileInfoList searchResourceFolders ( QString dirPath, QStringList fileMask );

private:
	bool 			m_yesToAll;

	QFileInfoList	m_soundFiles;
	QFileInfoList	m_firmwareFile;
	QFileInfoList	m_testFirmwareFile;
	QFileInfoList	m_bootloaderFile;

	static QString 	_soundFilePath;
	static QString 	_firmwareFilePath;
	static QString 	_testFirmwareFilePath;
	static QString 	_bootloaderFilePath;
};

#endif /* RESOURCE_H_ */
